/**
* \file: string_set.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_UTILS_STRING_SET_H
#define AMS_UTILS_STRING_SET_H

#include <stdbool.h>
#include <stdlib.h>
#include "automounter_types.h"

typedef struct string_set_t string_set_t;

typedef struct container_t container_t;

/**
 * @param delim the delimiter used to separate the elements from each other in the set. '\0' is an invalid value.
 */
error_code_t string_set_create(string_set_t **set_ptr, size_t chunk_size, unsigned int initial_chunk_cnt);

void string_set_free(string_set_t *set);

error_code_t string_set_add(string_set_t **set_ptr, const char *item);

bool string_set_contains_item(string_set_t *set, const char *item);

bool string_set_does_item_match(string_set_t *set, const char *item);

container_t *string_set_first_item_container(string_set_t *set);

container_t *string_set_next_item_container(string_set_t *set, container_t *cur_container);

const char * string_set_get_item(container_t *container);


#endif
